
/* exported  mc_dvi_cfg_get_sendcard_connect*/
/* exported  mc_dvi_click_custom*/

/* global $*/
/* global mc_hw_get_card_connect*/
/* global mc_sdk_param*/
/* global construct_dvi_cfg_options_arr*/
/* global g_obj_lang*/
/* global mc_ui_select*/
/* global mc_dvi_update_send_to_sdk */
/* global mc_dvi_open_custom */
/* global mc_dvi_modify_opt */
/* global g_obj_dvi_data */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取发送卡连接 && 获取dvi配置 && 构造布局
 * 参数:
 *    @param {Promise <Function>} init_callback 初始化回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-06-01
 *       内容 : 所有代码
************************************************************************************************/
function mc_dvi_cfg_get_sendcard_connect(init_callback) {
    if ("function" !== typeof init_callback) {
        return;
    }

    var m_obj_sdk_connect = new mc_hw_get_card_connect();
    var m_obj_dvi_data = {};

    // add prototype
    m_obj_sdk_connect.get_dvi_cfg = function (obj_sdk_param, callback) {
        return this.request("HW_SENDCARD_DVI_CFG", obj_sdk_param, callback);
    };

    m_obj_sdk_connect.get_send(new mc_sdk_param(), function (e_send, o_sdk_send) {
        var ui_param_cnt = o_sdk_send.get_param_cnt();
        var str_code_name = o_sdk_send.get_param_name(0);
        var obj_sdk_dvi_cgf = new mc_sdk_param();

        if (1 === ui_param_cnt && "ERROR_CODE" === str_code_name) {
            var str_nodata = "<p style='color:red;text-align: center;' control_type='nomarl_text' lang_id='MC_LANG_POPOUT_HARDWARE_CONNECT_FAIL_CHECK_HARDWARE'>连接硬件失败，请检查硬件</p>";

            init_callback(str_nodata, m_obj_dvi_data);
            return;
        }

        var ui_send_i = 0;

        for (var ui_i = 0; ui_i < ui_param_cnt; ui_i++) {
            var str_name = o_sdk_send.get_param_name(ui_i);
            var str_val = o_sdk_send.get_param_value(str_name);

            if ("ERROR_CODE" === str_name) {
                continue;
            }

            if (str_val && -1 !== str_val.indexOf(":") ) {
                obj_sdk_dvi_cgf.set_param_value(ui_send_i + "", "");
                ui_send_i++;
            }
        }

        mc_dvi_get_sdk(obj_sdk_dvi_cgf);
    });


    function mc_dvi_get_sdk(obj_sdk) {
        m_obj_sdk_connect.get_dvi_cfg(obj_sdk, function (e_dvi, o_sdk_dvi) {
            var ui_param_cnt = o_sdk_dvi.get_param_cnt();
            var str_html = "";

            for (var ui_dvi_i = 0; ui_dvi_i < ui_param_cnt; ui_dvi_i++) {
                var str_name_id = o_sdk_dvi.get_param_name(ui_dvi_i);
                var str_name = "S" + str_name_id;

                if ("ERROR_CODE" === str_name_id) {
                    continue;
                }

                var obj_data = {
                    index: str_name_id
                };

                var str = mc_dvi_construct_item(o_sdk_dvi, str_name_id, obj_data);

                str_html += "<div class='card_dvi_cfg mc_dvi_cfg_item' card_name='" + str_name + "'>" + str + "</div>";
                m_obj_dvi_data[str_name] = obj_data;
            }

            init_callback(str_html, m_obj_dvi_data);
        });
    }

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    构造单张卡html
     * 参数:
     *    @param { Promise<String> } obj_param 请求dvi配置返回参数
     *    @param { Promise<String> } str_name 卡名称; json串name_id; 全局数据对象key
     *    @param { Promise<String> } obj_data 卡数据
     * 返回:
     *    @returns { Promise<String> } 参数1
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-06-01
     *       内容 : 所有代码
    ************************************************************************************************/
    function mc_dvi_construct_item(obj_param, str_name, obj_data) {
        var obj_item_sel = new mc_ui_select();
        var arr_opt = construct_dvi_cfg_options_arr(str_name + "", obj_param);
        var arr_name_val = obj_param.get_param_value(str_name);

        if (arr_opt) {
            obj_item_sel.set_arr(arr_opt.opt);
            // 保存自定义值
            obj_data.dvi_cfg = {
                // 构造控件的对象
                obj_item: obj_item_sel,
                // 控件的下拉列表选项值
                opt: arr_opt.opt
            };
        }

        // obj_item_sel.set_style_width("280px");
        obj_item_sel.set_val(arr_name_val);
        obj_item_sel.on_val_chg = mc_dvi_update_item;

        // 当前分辨率
        var str_cut_dvi = "<div class='mc_dvi_cur'>" + g_obj_lang.get_item_val("MC_LANG_RESOLUTION") + ": " + arr_opt.cur + "</div>";
        // 自定义图标
        var str_btn_html = "<div id='' class='mc_btn mc_btn_dvi_cfg icon-edit' lang_id=''  title='" + g_obj_lang.get_item_val("MC_LANG_BTN_CUSTOM") + "' onclick='mc_dvi_click_custom(this)'>" + "</div>";
        // 下拉框
        var str_opt_sel = "<div class='item_wrap mc_dvi_opt'>" + obj_item_sel.get_html_txt() + "</div>";
        // 组合
        var str_item = "<div class='mc_dvi_center'>" +
                        "<div class='mc_dvi_title'>S" + (Number(obj_data.index) + 1) + "</div>" + str_cut_dvi + str_opt_sel + "</div>" +
                        "<div class='mc_spilt_div_vertical'></div>" + str_btn_html;

        return str_item;
    }
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    分辨率控件 on_val_chg
 * 参数:
 *    @param { Promise<String> } id 控件id
 *    @param { Promise<String> } val 更新值
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-06-01
 *       内容 : 所有代码
************************************************************************************************/
function mc_dvi_update_item(id, val) {
    // console.log("[分辨率更新]",id, val);
    var obj_opt = document.getElementById(id);

    if (obj_opt) {
        var $obj_parent = $(obj_opt).parents(".mc_dvi_cfg_item");

        if ($obj_parent.length) {
            var str_card_name = $obj_parent[0].getAttribute("card_name");

            mc_dvi_update_send_to_sdk(g_obj_dvi_data[str_card_name], val);
        }
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    点击自定义按钮; 打开自定义弹窗
 * 参数:
 *    @param { Promise<Object> } obj 按钮对象
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-06-01
 *       内容 : 所有代码
************************************************************************************************/
function mc_dvi_click_custom(obj) {
    if (obj) {
        var $obj_parent = $(obj).parents(".mc_dvi_cfg_item");

        if ($obj_parent.length) {
            var str_card_name = $obj_parent[0].getAttribute("card_name");

            mc_dvi_open_custom(str_card_name, g_obj_dvi_data[str_card_name], function (o_param) {
                if ("object" === typeof o_param) {
                    mc_dvi_modify_opt(o_param, g_obj_dvi_data[o_param.NAME]);
                }
            });
        }
    }
}


